/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.provisional.api;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.tm.internal.terminal.connector.TerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class TerminalConnectorExtension {
    private static ITerminalConnector makeConnector(final IConfigurationElement config) {
        String hidden;
        String name;
        String id = config.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = config.getAttribute("class");
        }
        if ((name = config.getAttribute("name")) == null || name.length() == 0) {
            name = id;
        }
        boolean isHidden = (hidden = config.getAttribute("hidden")) != null ? new Boolean(hidden) : false;
        TerminalConnector.Factory factory = new TerminalConnector.Factory(){

            public TerminalConnectorImpl makeConnector() throws Exception {
                return (TerminalConnectorImpl)config.createExecutableExtension("class");
            }
        };
        return new TerminalConnector(factory, id, name, isHidden);
    }

    public static ITerminalConnector makeTerminalConnector(String id) {
        IConfigurationElement[] config = RegistryFactory.getRegistry().getConfigurationElementsFor("com.aptana.org.eclipse.tm.terminal.terminalConnectors");
        int i = 0;
        while (i < config.length) {
            if (id.equals(config[i].getAttribute("id"))) {
                return TerminalConnectorExtension.makeConnector(config[i]);
            }
            ++i;
        }
        return null;
    }

    public static ITerminalConnector[] makeTerminalConnectors() {
        IConfigurationElement[] config = RegistryFactory.getRegistry().getConfigurationElementsFor("com.aptana.org.eclipse.tm.terminal.terminalConnectors");
        ArrayList<ITerminalConnector> result = new ArrayList<ITerminalConnector>();
        int i = 0;
        while (i < config.length) {
            result.add(TerminalConnectorExtension.makeConnector(config[i]));
            ++i;
        }
        return result.toArray(new ITerminalConnector[result.size()]);
    }
}

